package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.InspectionAuthorityEntity;
import com.biz.crm.mdm.business.user.local.repository.InspectionAuthorityRepository;
import com.biz.crm.mdm.business.user.sdk.dto.InspectionAuthorityDto;
import com.biz.crm.mdm.business.user.sdk.service.InspectionAuthorityService;
import com.biz.crm.mdm.business.user.sdk.vo.InspectionAuthorityVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName InspectionAuthorityServiceImpl
 * @Description 稽查权限Service实现
 * @AUTHOR WangJJ
 * @DATE 2023/6/16 16:49
 **/
@Service
@Slf4j
public class InspectionAuthorityServiceImpl implements InspectionAuthorityService {

    @Autowired(required = false)
    private InspectionAuthorityRepository inspectionAuthorityRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<InspectionAuthorityVo> listByConditions(InspectionAuthorityDto dto) {
        Validate.notNull(dto,"请求参数不能为空");
        Validate.notNull(dto.getRoleCode(),"角色编码不能为空");
        List<InspectionAuthorityEntity> authorityEntityList = this.inspectionAuthorityRepository.listByConditions(dto);
        List<InspectionAuthorityVo> inspectionAuthorityVos = (ArrayList<InspectionAuthorityVo>)this.nebulaToolkitService.copyCollectionByBlankList(authorityEntityList, InspectionAuthorityEntity.class, InspectionAuthorityVo.class, HashSet.class, ArrayList.class);
        return inspectionAuthorityVos;
    }

    @Override
    public void savaOrUpdate(List<InspectionAuthorityDto> dtos) {
        //验证
        this.createValidation(dtos);

        //先删除原有数据,物理删除
        List<String> roleCodes = dtos.stream().map(o -> o.getRoleCode()).distinct().collect(Collectors.toList());
        this.inspectionAuthorityRepository.removeByRoleCode(roleCodes);

        Collection<InspectionAuthorityEntity> entities = this.nebulaToolkitService.copyCollectionByBlankList(dtos, InspectionAuthorityDto.class, InspectionAuthorityEntity.class, HashSet.class, ArrayList.class);
        entities.forEach(o -> {
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });

        this.inspectionAuthorityRepository.saveOrUpdateBatch(entities);

    }

    private void createValidation(List<InspectionAuthorityDto> dtos){
        Validate.notEmpty(dtos,"新增数据不能为空");
        dtos.forEach(o -> {
            o.setId(null);
            Validate.notBlank(o.getRoleCode(),"角色编码不能为空");
            Validate.notBlank(o.getColumnCode(),"稽查字段编码不能为空");
            Validate.notBlank(o.getColumnName(),"稽查字段名称不能为空");
        });
    }
}
