package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.local.service.UserPositionService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 职位-用户关联表(UserPosition)表服务实现类
 *
 * @author xi.peng
 * @since 2021-11-05 15:02:58
 */
@Service
public class UserPositionServiceImpl implements UserPositionService {
  
  @Autowired(required = false)
  private UserPositionRepository userPositionRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<UserPositionEntity> findByPositionCode(Collection<String> positionCodes) {
    if (CollectionUtils.isEmpty(positionCodes)) {
      return new ArrayList<>();
    }
    return this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
  }

  @Override
  public List<UserPositionVo> findByUserName(String userName) {
    Validate.notNull(userName, "查询用户关联职位信息时，用户名称不能为空！");
    String tenantCode = TenantUtils.getTenantCode();
    List<UserPositionEntity> userPositionEntities = this.userPositionRepository.findByUserName(tenantCode,
        userName);
    if (CollectionUtils.isEmpty(userPositionEntities)){
      return null;
    }
   List<UserPositionVo>userPositionVos = (List<UserPositionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(userPositionEntities,UserPositionEntity.class,UserPositionVo.class,
        HashSet.class,ArrayList.class);
    return userPositionVos;
  }
}
