package com.biz.crm.mdm.business.user.local.service.internal;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.entity.UserRelateWarehouseEntity;
import com.biz.crm.mdm.business.user.local.repository.UserRelateWarehouseRepository;
import com.biz.crm.mdm.business.user.local.repository.UserRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseSearchDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelateWarehouseService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelateWarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author chuyi
 * @version 1.0
 * @description: 企业用户与仓库关联表服务实现类
 * @date 2023/6/25 11:13
 */
@Service
public class UserRelateWarehouseServiceImpl implements UserRelateWarehouseService {
    @Autowired(required = false)
    private UserRelateWarehouseRepository userRelateWarehouseRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private UserRepository userRepository;



    /**
     * 企业用户绑定仓库
     * @param dto
     */
    @Override
    @Transactional
    public void bind(UserRelateWarehouseDto dto) {
        Validate.notNull(dto,"参数不能为空");
        Validate.isTrue(CollectionUtils.isNotEmpty(dto.getWarehouseCodeList()),"仓库编码不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(dto.getUserCode()),"企业用户编码不能为空");
        List<UserRelateWarehouseEntity> entityList = this.userRelateWarehouseRepository.findByUserCodesAndWarehoseCodes(dto.getUserCode(), dto.getWarehouseCodeList());
        Validate.isTrue(CollectionUtils.isEmpty(entityList),"不能重复绑定");
        List<UserRelateWarehouseEntity> list = new ArrayList<>();
        dto.getWarehouseCodeList().stream().forEach(o->{
            UserRelateWarehouseEntity entity = new UserRelateWarehouseEntity();
            entity.setUserCode(dto.getUserCode());
            entity.setWarehouseCode(o);
            entity.setTenantCode(TenantUtils.getTenantCode());
            list.add(entity);
        });
        this.userRelateWarehouseRepository.saveBatch(list);
    }
//

    /**
     * 解除企业用户绑定
     * @param dto
     */
    @Override
    @Transactional
    public void unbind(UserRelateWarehouseDto dto) {
          Validate.notNull(dto,"解绑参数缺失");
          Validate.isTrue(CollectionUtils.isNotEmpty(dto.getWarehouseCodeList()),"仓库编码参数缺失");
          Validate.isTrue(StringUtils.isNotEmpty(dto.getUserCode()),"客户用户编码参数缺失");
        List<UserRelateWarehouseEntity> list = this.userRelateWarehouseRepository.findByUserCodesAndWarehoseCodes(dto.getUserCode(), dto.getWarehouseCodeList());
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        this.unbind(dto.getUserCode(),dto.getWarehouseCodeList(),true);
    }

    @Override
    public List<UserRelateWarehouseVo> findByCode(UserRelateWarehouseSearchDto dto) {
        Validate.isTrue(StringUtils.isNotEmpty(dto.getUserName()),"用户名不能为空");
        List<UserRelateWarehouseVo> list = Lists.newLinkedList();
         //通过用户名查询用户
        UserEntity user = this.userRepository.lambdaQuery()
                .eq(UserEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(UserEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .eq(UserEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(UserEntity::getUserName, dto.getUserName())
                .one();
//        通过用户code查询用户关联的仓库
        if (ObjectUtils.isNotEmpty(user)) {
            List<UserRelateWarehouseEntity> entityList = this.userRelateWarehouseRepository.lambdaQuery()
                    .eq(UserRelateWarehouseEntity::getTenantCode, TenantUtils.getTenantCode())
                    .eq(UserRelateWarehouseEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                    .eq(UserRelateWarehouseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(UserRelateWarehouseEntity::getUserCode, user.getUserCode())
                    .list();
            List<String> warehouseIds = this.userRelateWarehouseRepository.findByCode(user);
//            if (CollectionUtils.isNotEmpty(entityList)){
//                entityList.stream().forEach(o->{
//                    UserRelateWarehouseVo vo = this.nebulaToolkitService.copyObjectByWhiteList(o, UserRelateWarehouseVo.class, HashSet.class, ArrayList.class);
//                    vo.setWarehouseId();
//
//                });
//            }
            if (CollectionUtils.isNotEmpty(entityList) && CollectionUtils.isNotEmpty(warehouseIds)){
                for (int i = 0; i < entityList.size(); i++) {
                    UserRelateWarehouseVo vo = this.nebulaToolkitService.copyObjectByWhiteList(entityList.get(i), UserRelateWarehouseVo.class, HashSet.class, ArrayList.class);
                    vo.setWarehouseId(warehouseIds.get(i));
                    vo.setUserId(user.getId());
                    list.add(vo);
                }
            }
            return list;
        }
     return list;
    }

    /**
     * 解绑
     * @param
     * @param needNotIfier
     */
    @Transactional
    public void unbind(String userCode,List<String> warehouseCodeList, boolean needNotIfier) {
         Validate.isTrue(CollectionUtils.isNotEmpty(warehouseCodeList),"仓库编码集合不能为空");
         Validate.isTrue(StringUtils.isNotEmpty(userCode),"解绑用户编码不能为空");
         this.userRelateWarehouseRepository.deleteByIdsAndTenantCode(userCode,warehouseCodeList,TenantUtils.getTenantCode());
         if (Boolean.FALSE.equals(needNotIfier)){
             return;
         }
    }
}
