/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.InspectionAuthorityEntity;
import com.biz.crm.mdm.business.user.local.repository.InspectionAuthorityRepository;
import com.biz.crm.mdm.business.user.sdk.dto.InspectionAuthorityDto;
import com.biz.crm.mdm.business.user.sdk.service.InspectionAuthorityService;
import com.biz.crm.mdm.business.user.sdk.vo.InspectionAuthorityVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InspectionAuthorityServiceImpl
implements InspectionAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(InspectionAuthorityServiceImpl.class);
    @Autowired(required=false)
    private InspectionAuthorityRepository inspectionAuthorityRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<InspectionAuthorityVo> listByConditions(InspectionAuthorityDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InspectionAuthorityEntity> authorityEntityList = this.inspectionAuthorityRepository.listByConditions(dto);
        ArrayList inspectionAuthorityVos = (ArrayList)this.nebulaToolkitService.copyCollectionByBlankList(authorityEntityList, InspectionAuthorityEntity.class, InspectionAuthorityVo.class, HashSet.class, ArrayList.class, new String[0]);
        return inspectionAuthorityVos;
    }

    public void savaOrUpdate(List<InspectionAuthorityDto> dtos) {
        this.createValidation(dtos);
        List<String> roleCodes = dtos.stream().map(o -> o.getRoleCode()).distinct().collect(Collectors.toList());
        this.inspectionAuthorityRepository.removeByRoleCode(roleCodes);
        Collection entities = this.nebulaToolkitService.copyCollectionByBlankList(dtos, InspectionAuthorityDto.class, InspectionAuthorityEntity.class, HashSet.class, ArrayList.class, new String[0]);
        entities.forEach(o -> {
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.inspectionAuthorityRepository.saveOrUpdateBatch(entities);
    }

    private void createValidation(List<InspectionAuthorityDto> dtos) {
        Validate.notEmpty(dtos, (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.forEach(o -> {
            o.setId(null);
            Validate.notBlank((CharSequence)o.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getColumnCode(), (String)"\u7a3d\u67e5\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getColumnName(), (String)"\u7a3d\u67e5\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }
}

