/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.local.service.UserPositionService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPositionServiceImpl
implements UserPositionService {
    @Autowired(required=false)
    private UserPositionRepository userPositionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<UserPositionEntity> findByPositionCode(Collection<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return new ArrayList<UserPositionEntity>();
        }
        return this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
    }

    @Override
    public List<UserPositionVo> findByUserName(String userName) {
        Validate.notNull((Object)userName, (String)"\u67e5\u8be2\u7528\u6237\u5173\u8054\u804c\u4f4d\u4fe1\u606f\u65f6\uff0c\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<UserPositionEntity> userPositionEntities = this.userPositionRepository.findByUserName(tenantCode, userName);
        if (CollectionUtils.isEmpty(userPositionEntities)) {
            return null;
        }
        List userPositionVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(userPositionEntities, UserPositionEntity.class, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return userPositionVos;
    }
}

