/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.entity.UserRelateWarehouseEntity;
import com.biz.crm.mdm.business.user.local.repository.UserRelateWarehouseRepository;
import com.biz.crm.mdm.business.user.local.repository.UserRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseSearchDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelateWarehouseService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelateWarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRelateWarehouseServiceImpl
implements UserRelateWarehouseService {
    @Autowired(required=false)
    private UserRelateWarehouseRepository userRelateWarehouseRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UserRepository userRepository;

    @Transactional
    public void bind(UserRelateWarehouseDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getWarehouseCodeList()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getUserCode()), (String)"\u4f01\u4e1a\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserRelateWarehouseEntity> entityList = this.userRelateWarehouseRepository.findByUserCodesAndWarehoseCodes(dto.getUserCode(), dto.getWarehouseCodeList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entityList), (String)"\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a", (Object[])new Object[0]);
        ArrayList list = new ArrayList();
        dto.getWarehouseCodeList().stream().forEach(o -> {
            UserRelateWarehouseEntity entity = new UserRelateWarehouseEntity();
            entity.setUserCode(dto.getUserCode());
            entity.setWarehouseCode((String)o);
            entity.setTenantCode(TenantUtils.getTenantCode());
            list.add(entity);
        });
        this.userRelateWarehouseRepository.saveBatch(list);
    }

    @Transactional
    public void unbind(UserRelateWarehouseDto dto) {
        Validate.notNull((Object)dto, (String)"\u89e3\u7ed1\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getWarehouseCodeList()), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getUserCode()), (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        List<UserRelateWarehouseEntity> list = this.userRelateWarehouseRepository.findByUserCodesAndWarehoseCodes(dto.getUserCode(), dto.getWarehouseCodeList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.unbind(dto.getUserCode(), dto.getWarehouseCodeList(), true);
    }

    public List<UserRelateWarehouseVo> findByCode(UserRelateWarehouseSearchDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getUserName()), (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LinkedList list = Lists.newLinkedList();
        UserEntity user = (UserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UserEntity::getUserName, (Object)dto.getUserName())).one());
        if (ObjectUtils.isNotEmpty((Object)((Object)user))) {
            List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userRelateWarehouseRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UserRelateWarehouseEntity::getUserCode, (Object)user.getUserCode())).list();
            List<String> warehouseIds = this.userRelateWarehouseRepository.findByCode(user);
            if (CollectionUtils.isNotEmpty((Collection)entityList) && CollectionUtils.isNotEmpty(warehouseIds)) {
                for (int i = 0; i < entityList.size(); ++i) {
                    UserRelateWarehouseVo vo = (UserRelateWarehouseVo)this.nebulaToolkitService.copyObjectByWhiteList(entityList.get(i), UserRelateWarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setWarehouseId(warehouseIds.get(i));
                    vo.setUserId(user.getId());
                    list.add(vo);
                }
            }
            return list;
        }
        return list;
    }

    @Transactional
    public void unbind(String userCode, List<String> warehouseCodeList, boolean needNotIfier) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(warehouseCodeList), (String)"\u4ed3\u5e93\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)userCode), (String)"\u89e3\u7ed1\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.userRelateWarehouseRepository.deleteByIdsAndTenantCode(userCode, warehouseCodeList, TenantUtils.getTenantCode());
        if (Boolean.FALSE.equals(needNotIfier)) {
            return;
        }
    }
}

