package com.biz.crm.mdm.business.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 职位-用户关联表分页查询dto
 *
 * @author xi.peng
 * @since 2021-11-05 15:01:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "UserPositionPageDto", description = "职位-用户关联表分页查询dto")
public class UserPositionPageDto extends TenantDto {

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("用户登录名")
  private String userName;

  @ApiModelProperty("是否主职位 1是 0否")
  private Boolean primaryFlag;

  @ApiModelProperty("是否当前职位 1是 0否")
  private Boolean currentFlag;

}

