package com.biz.crm.mdm.business.user.sdk.service;

import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 用户表(User)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-04 17:38:46
 */
public interface UserFeignVoService {

  /**
   * 按照条件查询用户账号集合
   *
   * @param dto 查询集合
   * @return 用户账号信息集合
   */
  default Set<String> findUserNamesByUserDto(UserFeignDto dto) {
    return new HashSet<>();
  }

  /**
   * 按用户账号查询集合(包含职位和组织)
   *
   * @param userNames 用户帐号集合
   * @return 用户信息集合
   */
  default List<UserVo> findByUserNames(List<String> userNames) {
    return new ArrayList<>();
  }
}
