package com.biz.crm.mdm.business.user.sdk.service;

import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;

import java.util.List;
import java.util.Set;

/**
 * 用户信息服务接口
 *
 * @author xi.peng
 * @since 2021-11-05 15:11:43
 */
public interface UserInfoVoService {

  /**
   * 根据职位集合查询
   *
   * @param positionCodes 职位集合
   * @return
   */
  List<UserInfoVo> findByPositionCodes(Set<String> positionCodes);

  /**
   * 根据用户账号集合查询
   *
   * @param userNames 用户账号集合
   * @return
   */
  List<UserInfoVo> findByUserNames(Set<String> userNames);

}
