package com.biz.crm.mdm.business.user.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatPageDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserWeChatBindDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 用户与微信关联表(UserRelWeChat)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-05 15:11:53
 */
public interface UserRelWeChatVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<UserRelWeChatVo> findByConditions(Pageable pageable, UserRelWeChatPageDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  UserRelWeChatVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  void create(UserRelWeChatDto dto);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(UserRelWeChatDto dto);

  /**
   * 根据用户账号解除用户关联的所有微信，并退出登录
   *
   * @param userNameList
   */
  void deleteByUserNames(List<String> userNameList);

  /**
   * 查询用户关联的微信列表
   *
   * @param dto
   */
  List<UserRelWeChatVo> findByUserRelWeChatDto(UserRelWeChatDto dto);

  /**
   * 通过用户与微信绑定dto创建用户与微信关系
   *
   * @param dto 参数dto
   */
  void createByUserWeChatBindDto(UserWeChatBindDto dto);
}
