package com.biz.crm.mdm.business.user.sdk.service;

import com.biz.crm.mdm.business.user.sdk.vo.UserVo;

/**
 * 用户有效性检查服务接口
 *
 * @author pengxi
 */
public interface UserValidityCheckService {
  /**
   * 根据账号校验【管理端】用户有效性
   *
   * 1、用户手机号在对应的用户表中是否存在
   * 2、手机号对应用户是否禁用
   * 3、手机号对应用户是否逻辑删除
   * 4、手机号对应用户账号是否过期
   * 5、手机号对应用户账号关联职位是否变更
   *
   * @param account 账号
   * @return UserVo 用户信息
   */
  UserVo verificationManageByAccount(String account);

  /**
   * 根据手机号校验【管理端】用户有效性
   *
   * 1、用户手机号在对应的用户表中是否存在
   * 2、手机号对应用户是否禁用
   * 3、手机号对应用户是否逻辑删除
   * 4、手机号对应用户账号是否过期
   * 5、手机号对应用户账号关联职位是否变更
   *
   * @param phone 手机号
   * @return UserVo 用户信息
   */
  UserVo verificationManageByPhone(String phone);

}