package com.biz.crm.mdm.business.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户与钉钉关联表dto
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 22:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "UserRelDingTalkDto", description = "用户与钉钉关联表dto")
public class UserRelDingTalkDto extends TenantDto {

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("钉钉用户ID")
    private String dingTalkUserId;

    @ApiModelProperty("钉钉员工姓名")
    private String dingTalkName;

    @ApiModelProperty("钉钉职位")
    private String dingTalkTitle;

    @ApiModelProperty("钉钉手机号码")
    private String mobile;

    @ApiModelProperty("是否完成了实名认证;true：已认证;false：未认证")
    private Boolean realAuthed;

}

