package com.biz.crm.mdm.business.user.sdk.event;

import com.biz.crm.mdm.business.user.sdk.vo.UserVo;

import java.util.List;

/**
 * 用户表变更事件通知接口
 *
 * @author xi.peng
 * @since 2021-11-04 17:40:50
 */
public interface UserEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    default void onCreate(UserVo vo) {
    }

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    default void onUpdate(UserVo oldVo, UserVo newVo) {

    }

    /**
     * 启用时触发
     *
     * @param list
     */
    default void onEnable(List<UserVo> list) {

    }

    /**
     * 禁用时触发
     *
     * @param list
     */
    default void onDisable(List<UserVo> list) {
    }

    /**
     * 删除时触发
     *
     * @param list
     */
    default void onDelete(List<UserVo> list) {

    }
}

