package com.biz.crm.mdm.business.user.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 职位-用户关联表(UserPosition)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-05 15:11:43
 */
public interface UserPositionVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<UserPositionVo> findByConditions(Pageable pageable, UserPositionPageDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  UserPositionVo findDetailById(String id);

  /**
   * 根据用户账号查询职位-用户关系
   *
   * @param tenantCode
   * @param userName
   * @return
   */
  List<UserPositionVo> findByUserName(String tenantCode, String userName);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  void create(UserPositionDto dto);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(UserPositionDto dto);


  /**
   * 根据用户账号移除关系
   *
   * @param userNames 用户账号
   */
  void deleteByUserNames(Collection<String> userNames);

  /**
   * 重置用户职位关系
   *
   * @param userName 用户账号
   * @param primaryPositionCode 主职位编码
   * @param positionCodeList 职位集合
   */
  void rebindByUserName(String userName, String primaryPositionCode, List<String> positionCodeList, List<UserPositionDto> positionList);

  /**
   * 更新用户当前职位
   * 1、根据用户账号更新所有关联记录"是否当前职位"为“否”
   * 2、根据用户账号及当前职位编码更新关联记录"是否当前职位"为“是”
   *
   * @param userName 用户账号
   * @param currentFlagPositionCode 当前职位
   */
  void updateCurrentFlagPosition(String userName, String currentFlagPositionCode);

  /**
   * 找到所有用户
   *
   * @param tenantCode 租户代码
   * @return {@link List}<{@link UserPositionVo}>
   */
  List<UserPositionVo> findAllUser(String tenantCode);

  /**
   * 根据岗位编码集合查询
   *
   * @param positionCodes 岗位编码
   * @return {@link Set}<{@link UserPositionVo}>
   */
  Set<UserPositionVo> findByPositionCodeIn(Collection<String> positionCodes);

  /**
   * 重新绑定MDG用户职位关系（MDG用，前面方法已做校验，此处不做校验）
   *
   * @param userPositionDtoList
   * @author huojia
   * @date 2022/12/31 0:38
   **/
  void rebindMdgUser(List<UserPositionDto> userPositionDtoList);

  /**
   * 批量查询
   * @author huojia
   * @date 2023/1/4 10:59
   * @param userNameList
   * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo>
   **/
  List<UserPositionVo> listByUserNameList(List<String> userNameList);
}
