package com.biz.crm.mdm.business.user.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户信息vo
 *
 * @author xi.peng
 * @since 2021-11-05 15:01:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户信息Vo")
public class UserInfoVo extends TenantVo {
  private static final long serialVersionUID = 105992914324272131L;

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 人员中心编号
   */
  @ApiModelProperty("人员中心编号")
  private String userCenterCode;

  /**
   * 密码（经过加密的）
   */
  @ApiModelProperty("密码（经过加密的）")
  private String userPassword;

  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 性别
   */
  @ApiModelProperty("性别")
  private String gender;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 生效时间
   */
  @ApiModelProperty("生效时间")
  private String endTime;

  /**
   * 失效时间
   */
  @ApiModelProperty("失效时间")
  private String startTime;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  private String email;

  /**
   * 锁定状态 003/009
   */
  @ApiModelProperty("锁定状态 003/009")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @ApiModelProperty("最后一次登录时间")
  private String lastLoginTime;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 是否强制修改密码
   */
  @ApiModelProperty("是否强制修改密码")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @ApiModelProperty("工号")
  private String jobCode;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String employeeType;

  /**
   * 员工状态
   */
  @ApiModelProperty("员工状态")
  private String employeeStatus;

  /**
   * 设备绑定状态
   */
  @ApiModelProperty("设备绑定状态")
  private String verifyStatus;

  /**
   * 实名认证状态
   */
  @ApiModelProperty("设备绑定状态")
  private String deviceBindStatus;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @ApiModelProperty("身份证地址")
  private String identityCardAddress;

  /**
   * 民族
   */
  @ApiModelProperty("民族")
  private String nationality;

  /**
   * 现住址
   */
  @ApiModelProperty("现住址")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @ApiModelProperty("政治面貌")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @ApiModelProperty("每隔三个月修改密码更新时间")
  private Date updatePasswordDate;

  /**
   * 设备码
   */
  @ApiModelProperty("设备码")
  private String registrationId;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位是否主职位 1是 0否
   */
  @ApiModelProperty("职位是否主职位 1是 0否")
  private Boolean primaryFlag;

  @ApiModelProperty("生效状态 003停用，009启用")
  private String enableStatus;

  @ApiModelProperty("是否删除 003停用，009启用")
  private String delFlag;
}

