package com.biz.crm.mdm.business.user.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户与钉钉关联表Vo
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 21:55
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户与钉钉关联表Vo")
public class UserRelDingTalkVo extends TenantVo {

    private static final long serialVersionUID = -5467570594633403221L;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("钉钉用户ID")
    private String dingTalkUserId;

    @ApiModelProperty("钉钉员工姓名")
    private String dingTalkName;

    @ApiModelProperty("钉钉职位")
    private String dingTalkTitle;

    @ApiModelProperty("钉钉手机号码")
    private String mobile;

    @ApiModelProperty("是否完成了实名认证;true：已认证;false：未认证")
    private Boolean realAuthed;

}

