package com.biz.crm.mdm.business.user.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 用户表vo
 *
 * @author xi.peng
 * @since 2021-11-04 17:40:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户表Vo")
public class UserVo extends TenantFlagOpVo {
  
  private static final long serialVersionUID = 47313500757246385L;

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 人员中心编号
   */
  @ApiModelProperty("人员中心编号")
  private String userCenterCode;

  @ApiModelProperty("企微人员id")
  private String wxUserId;

  @ApiModelProperty("微信unionId")
  private String unionId;

  /**
   * 密码（经过加密的）
   */
  @ApiModelProperty("密码（经过加密的）")
  private String userPassword;

  /**
   * 成本中心编码
   */
  @ApiModelProperty("成本中心编码")
  private String costCenterCode;

  /**
   * 成本中心名称
   */
  @ApiModelProperty("成本中心名称")
  private String costCenterName;

  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 用户来源
   */
  @ApiModelProperty("用户来源")
  private String userSource;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 性别
   */
  @ApiModelProperty("性别")
  private String gender;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 生效时间
   */
  @ApiModelProperty("生效时间")
  private String endTime;

  /**
   * 失效时间
   */
  @ApiModelProperty("失效时间")
  private String startTime;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  private String email;

  /**
   * 锁定状态 003/009
   */
  @ApiModelProperty("锁定状态 003/009")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @ApiModelProperty("最后一次登录时间")
  private String lastLoginTime;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 是否强制修改密码
   */
  @ApiModelProperty("是否强制修改密码")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @ApiModelProperty("工号")
  private String jobCode;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String employeeType;

  /**
   * 员工状态
   */
  @ApiModelProperty("员工状态")
  private String employeeStatus;

  /**
   * 实名认证状态
   */
  @ApiModelProperty("实名认证状态")
  private String verifyStatus;

  /**
   * 设备绑定状态
   */
  @ApiModelProperty("设备绑定状态")
  private String deviceBindStatus;

  /**
   * 可登录系统端口
   */
  @ApiModelProperty(value = "系统登录端口")
  private String sysLoginPort;

  /**
   * 绑定登录设备
   */
  @ApiModelProperty(value = "绑定登录设备")
  private String deviceCode;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @ApiModelProperty("身份证地址")
  private String identityCardAddress;

  /**
   * 民族
   */
  @ApiModelProperty("民族")
  private String nationality;

  /**
   * 现住址
   */
  @ApiModelProperty("现住址")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @ApiModelProperty("政治面貌")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @ApiModelProperty("每隔三个月修改密码更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date updatePasswordDate;

  /**
   * 设备码
   */
  @ApiModelProperty("设备码")
  private String registrationId;

  /**
   * 职位列表
   */
  @ApiModelProperty("职位列表")
  private List<UserPositionVo> positionList;

  /**
   * 职位层级编码
   */
  @ApiModelProperty("职位层级编码")
  private String positionLevelCode;

  /**
   * 职位层级名称
   */
  @ApiModelProperty("职位层级名称")
  private String positionLevelName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 职位编码
   */
  @ApiModelProperty("主职位编码")
  private String majorPositionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("主职位名称")
  private String majorPositionName;

  /**
   * 关联组织编码集合
   */
  @ApiModelProperty("关联组织编码集合")
  private List<String> relationOrgCodes;

  /**
   * 关联组织类型（层级）集合
   */
  @ApiModelProperty("关联组织类型（层级）集合")
  private List<String> relationOrgTypes;

  private List<String> sysLoginPorts;
}

