package com.biz.crm.mdm.business.user.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;


/**
 * 用户表dto
 *
 * @author xi.peng
 * @since 2021-11-04 17:40:50
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "UserDto", description = "用户表dto")
public class UserDto extends TenantFlagOpDto {

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 密码（经过加密的）
   */
  @ApiModelProperty("密码（经过加密的）")
  private String userPassword;

  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 性别
   */
  @ApiModelProperty("性别")
  private String gender;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 生效时间
   */
  @ApiModelProperty("生效时间")
  private String endTime;

  /**
   * 失效时间
   */
  @ApiModelProperty("失效时间")
  private String startTime;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  private String email;

  /**
   * 锁定状态 003/009
   */
  @ApiModelProperty("锁定状态 003/009")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @ApiModelProperty("最后一次登录时间")
  private String lastLoginTime;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 强制修改密码
   */
  @ApiModelProperty("强制修改密码")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @ApiModelProperty("工号")
  private String jobCode;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String employeeType;

  /**
   * 员工状态
   */
  @ApiModelProperty("员工状态")
  private String employeeStatus;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @ApiModelProperty("身份证地址")
  private String identityCardAddress;

  /**
   * 民族
   */
  @ApiModelProperty("民族")
  private String nationality;

  /**
   * 现住址
   */
  @ApiModelProperty("现住址")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @ApiModelProperty("政治面貌")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @ApiModelProperty("每隔三个月修改密码更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date updatePasswordDate;

  /**
   * 设备码
   */
  @ApiModelProperty("设备码")
  private String registrationId;
  /**
   * 组织ID
   */
  @TableField(value = "org_id")
  private String orgId;

  /**
   * 职位列表
   */
  @ApiModelProperty("职位列表")
  private List<UserPositionDto> positionList;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库列表")
  private List<UserRelateWarehouseBindDto> warehouseList;
}

