package com.biz.crm.mdm.business.user.sdk.enums;

/**
 * 用户类型枚举
 *
 * @author pengxi
 */
public enum UserTypeEnum {
  USER("u", "企业用户"),
  CUSTOMER("c", "客户用户"),
  CONSUMER("consumer", "消费者用户"),
  TERMINAL("terminal", "终端用户"),
  CUSTOMER_EMPLOYEE("customer_employee", "经销商员工用户"),
  USER_GUIDE("user_guide", "企业导购用户"),
  ;

  UserTypeEnum(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  private String code;
  private String desc;

  public static UserTypeEnum getEnumByCode(String code) {
    if (code != null) {
      for (UserTypeEnum item :
          UserTypeEnum.values()) {
        if (item.getCode().equals(code)) {
          return item;
        }
      }
    }
    return null;
  }

  public static String getDescByCode(String code) {
    if (code != null) {
      UserTypeEnum anEnum = getEnumByCode(code);
      if (anEnum != null) {
        return anEnum.getDesc();
      }
    }
    return null;
  }

  public static boolean exist(String code) {
    if (code != null) {
      for (UserTypeEnum item :
          UserTypeEnum.values()) {
        if (item.getCode().equals(code)) {
          return true;
        }
      }
    }
    return false;
  }

  public String getCode() {
    return code;
  }


  public String getDesc() {
    return desc;
  }
}
