package com.biz.crm.mdm.business.user.sdk.event;

import com.biz.crm.mdm.business.user.sdk.vo.UserEventDtoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserEventResponse;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

public interface UserMEventListener extends NebulaEvent {

    /**
     * 创建时触发
     *
     * @param vo
     */
    UserEventResponse onCreate(UserEventDtoVo vo);

    /**
     * 编辑时触发
     *
     * @param newVo
     */
    UserEventResponse onUpdate(UserEventDtoVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    UserEventResponse onEnable(List<UserEventDtoVo> list);

    /**
     * 禁用时触发
     *
     * @param list
     */
    UserEventResponse onDisable(List<UserEventDtoVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    UserEventResponse onDelete(List<UserEventDtoVo> list);
}

