package com.biz.crm.mdm.business.user.sdk.service;

import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseSearchDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelateWarehouseVo;

import java.util.List;

/**
 * 企业用户-仓库关联表(UserRelateWarehouse)表服务接口
 *
 * @author chuyi
 * @since 2021-11-05 15:11:43
 */
public interface UserRelateWarehouseService {
    /**
     * 企业用户绑定仓库
     * @param dto
     */
    void bind(UserRelateWarehouseDto dto);

    /**
     * 解除企业用户绑定
     * @param dto
     */
    void unbind(UserRelateWarehouseDto dto);

    List<UserRelateWarehouseVo> findByCode(UserRelateWarehouseSearchDto dto);
}
