package com.biz.crm.mdm.business.user.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 职位-用户关联表vo
 *
 * @author xi.peng
 * @since 2021-11-05 15:01:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位-用户关联表Vo")
public class UserPositionVo extends TenantVo {
  private static final long serialVersionUID = 105992914324272131L;

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("用户登录名")
  private String userName;

  @ApiModelProperty("是否主职位 1是 0否")
  private Boolean primaryFlag;

  @ApiModelProperty("是否当前职位 1是 0否")
  private Boolean currentFlag;

  @ApiModelProperty("职位名称")
  private String positionName;

  @ApiModelProperty("职位ID标识")
  private String positionId;

  @ApiModelProperty("行政组织")
  private String orgId;

  /**
   * 组织编码集合
   */
  @ApiModelProperty("组织编码集合")
  private Set<String> orgCodes;
}

