package com.biz.crm.mdm.business.visitor.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.visitor.feign.feign.VisitorPhoneVoFeign;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhoneDto;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorPhoneVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户信息feign接口熔断类
 *
 * @author xi.peng
 * @since 2022-08-30 17:22:27
 */
@Slf4j
@Component
public class VisitorPhoneVoFeignFallbackImpl implements FallbackFactory<VisitorPhoneVoFeign> {
  @Override
  public VisitorPhoneVoFeign create(Throwable throwable) {
    return new VisitorPhoneVoFeign() {
      @Override
      public Result<VisitorPhoneVo> findDetailById(String id) {
        throw new UnsupportedOperationException("详情熔断");
      }

      @Override
      public Result<List<VisitorPhoneVo>> findByAccount(String account) {
        throw new UnsupportedOperationException("根据游客账号获取游客手机熔断");
      }

      @Override
      public Result<List<VisitorPhoneVo>> findByDefaultAccount() {
        throw new UnsupportedOperationException("根据默认游客账号获取游客手机熔断");
      }

      @Override
      public Result create(VisitorPhoneDto dto) {
        throw new UnsupportedOperationException("创建（根据自定义选中游客账号创建）熔断");
      }

      @Override
      public Result createByDefaultAccount(VisitorPhoneDto dto) {
        throw new UnsupportedOperationException("创建（根据默认游客账号创建）熔断");
      }

      @Override
      public Result updateLoginTimesByPhone(String phone) {
        throw new UnsupportedOperationException("根据手机号更新登录次数熔断");
      }
    };
  }
}
