package com.biz.crm.mdm.business.visitor.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.visitor.feign.feign.internal.VisitorPhoneVoFeignFallbackImpl;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhoneDto;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorPhoneVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户信息feign接口类
 *
 * @author xi.peng
 * @since 2022-08-30 17:22:27
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = VisitorPhoneVoFeignFallbackImpl.class
)
public interface VisitorPhoneVoFeign {

  /**
   * 详情
   *
   * @param id 游客手机表ID
   * @return 游客手机表Vo
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/v1/visitorPhone/visitorPhoneVo/findDetailById"})
  Result<VisitorPhoneVo> findDetailById(@RequestParam("id") String id);

  /**
   * 根据游客账号获取游客手机
   *
   * @param account 游客账号
   * @return 游客手机表Vo集合
   */
  @ApiOperation(value = "根据游客账号获取游客手机")
  @GetMapping(value = {"/v1/visitorPhone/visitorPhoneVo/findByAccount"})
  Result<List<VisitorPhoneVo>> findByAccount(@RequestParam("account") String account);

  /**
   * 根据默认游客账号获取游客手机
   *
   * @return 游客手机表Vo集合
   */
  @ApiOperation(value = "根据默认游客账号获取游客手机")
  @GetMapping(value = {"/v1/visitorPhone/visitorPhoneVo/findByDefaultAccount"})
  Result<List<VisitorPhoneVo>> findByDefaultAccount();

  /**
   * 创建（根据自定义选中游客账号创建）
   *
   * @param dto 游客手机表dto
   * @return 创建结果
   */
  @ApiOperation(value = "创建（根据自定义选中游客账号创建）")
  @PostMapping(value = "/v1/visitorPhone/visitorPhoneVo")
  Result create(@RequestBody VisitorPhoneDto dto);

  /**
   * 创建（根据默认游客账号创建）
   *
   * @param dto 游客手机表dto
   * @return 创建结果
   */
  @ApiOperation(value = "创建（根据默认游客账号创建）")
  @PostMapping(value = "/v1/visitorPhone/visitorPhoneVo/createByDefaultAccount")
  Result createByDefaultAccount(@RequestBody VisitorPhoneDto dto);

  /**
   * 根据手机号更新登录次数
   *
   * @param phone
   * @return
   */
  @ApiOperation(value = "根据手机号更新登录次数")
  @PostMapping(value = "/v1/visitorPhone/visitorPhoneVo/updateLoginTimesByPhone")
  Result updateLoginTimesByPhone(@RequestParam("phone") String phone);
}
