/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.visitor.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.visitor.local.entity.VisitorPhoneEntity;
import com.biz.crm.mdm.business.visitor.local.repository.VisitorPhoneRepository;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhoneDto;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhonePageDto;
import com.biz.crm.mdm.business.visitor.sdk.event.VisitorPhoneEventListener;
import com.biz.crm.mdm.business.visitor.sdk.service.VisitorAccountVoService;
import com.biz.crm.mdm.business.visitor.sdk.service.VisitorPhoneVoService;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorPhoneVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitorPhoneVoServiceImpl
implements VisitorPhoneVoService {
    private static final Logger log = LoggerFactory.getLogger(VisitorPhoneVoServiceImpl.class);
    @Autowired
    private VisitorPhoneRepository visitorPhoneRepository;
    @Autowired
    private VisitorAccountVoService visitorAccountVoService;
    @Autowired(required=false)
    private List<VisitorPhoneEventListener> visitorPhoneEventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<VisitorPhoneVo> findByConditions(Pageable pageable, VisitorPhonePageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new VisitorPhonePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.visitorPhoneRepository.findByConditions((Page<VisitorPhonePageDto>)page, dto);
    }

    public VisitorPhoneVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VisitorPhoneEntity entity = this.visitorPhoneRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (VisitorPhoneVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<VisitorPhoneVo> findByAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        List<VisitorPhoneEntity> entities = this.visitorPhoneRepository.findByAccount(TenantUtils.getTenantCode(), account);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorPhoneEntity.class, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<VisitorPhoneVo> findByDefaultAccount() {
        VisitorAccountVo visitorAccountVo = this.visitorAccountVoService.findDefaultAccount();
        Validate.notNull((Object)visitorAccountVo, (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u9ed8\u8ba4\u6e38\u5ba2\u8d26\u53f7\uff01", (Object[])new Object[0]);
        return this.findByAccount(visitorAccountVo.getAccount());
    }

    @Transactional
    public void create(VisitorPhoneDto dto) {
        List<VisitorPhoneEntity> entities;
        this.createValidation(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)dto.getAccount(), (String)"\u8bf7\u9009\u62e9\u6e38\u5ba2\u8d26\u53f7\uff01", (Object[])new Object[0]);
        VisitorAccountVo visitorAccountVo = this.visitorAccountVoService.findByAccount(dto.getAccount());
        Validate.notNull((Object)visitorAccountVo, (String)"\u6e38\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        if (BooleanEnum.FALSE.getCapital().equals(visitorAccountVo.getAttribute()) && CollectionUtils.isNotEmpty(entities = this.visitorPhoneRepository.findByAccount(TenantUtils.getTenantCode(), dto.getAccount()))) {
            Optional<VisitorPhoneEntity> visitorPhoneEntityOptional = entities.stream().filter(vp -> vp.getPhone().equals(dto.getPhone())).findFirst();
            Validate.isTrue((!visitorPhoneEntityOptional.isPresent() ? 1 : 0) != 0, (String)"\u5f53\u524d\u6e38\u5ba2\u8d26\u53f7\u53ea\u53ef\u88ab\u4e00\u4e2a\u7528\u6237\u4f7f\u7528\uff01", (Object[])new Object[0]);
        }
        VisitorPhoneEntity entity = (VisitorPhoneEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, VisitorPhoneEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.visitorPhoneRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            VisitorPhoneVo vo = (VisitorPhoneVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    @Transactional
    public void createByDefaultAccount(VisitorPhoneDto dto) {
        List<VisitorPhoneEntity> entities;
        this.createValidation(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        VisitorAccountVo visitorAccountVo = this.visitorAccountVoService.findDefaultAccount();
        Validate.notNull((Object)visitorAccountVo, (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u9ed8\u8ba4\u6e38\u5ba2\u8d26\u53f7", (Object[])new Object[0]);
        if (BooleanEnum.FALSE.getCapital().equals(visitorAccountVo.getAttribute()) && CollectionUtils.isNotEmpty(entities = this.visitorPhoneRepository.findByAccount(TenantUtils.getTenantCode(), dto.getAccount()))) {
            Optional<VisitorPhoneEntity> visitorPhoneEntityOptional = entities.stream().filter(vp -> vp.getPhone().equals(dto.getPhone())).findFirst();
            Validate.isTrue((!visitorPhoneEntityOptional.isPresent() ? 1 : 0) != 0, (String)"\u5f53\u524d\u6e38\u5ba2\u8d26\u53f7\u53ea\u53ef\u88ab\u4e00\u4e2a\u7528\u6237\u4f7f\u7528\uff01", (Object[])new Object[0]);
        }
        VisitorPhoneEntity entity = (VisitorPhoneEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, VisitorPhoneEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.visitorPhoneRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            VisitorPhoneVo vo = (VisitorPhoneVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    @Transactional
    public void update(VisitorPhoneDto dto) {
        this.updateValidation(dto);
        VisitorPhoneEntity oldEntity = this.visitorPhoneRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        VisitorPhoneEntity entity = (VisitorPhoneEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, VisitorPhoneEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.visitorPhoneRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            VisitorPhoneVo oldVo = (VisitorPhoneVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            VisitorPhoneVo newVo = (VisitorPhoneVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onUpdate(oldVo, newVo));
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorPhoneEntity> entities = this.visitorPhoneRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorPhoneRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorPhoneEntity.class, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onEnable(voList));
        }
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorPhoneEntity> entities = this.visitorPhoneRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorPhoneRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorPhoneEntity.class, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onDisable(voList));
        }
    }

    @Transactional
    public void updateLoginTimesByPhone(String phone) {
        Validate.notBlank((CharSequence)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean bool = this.visitorPhoneRepository.updateLoginTimesByPhone(TenantUtils.getTenantCode(), phone);
        Validate.isTrue((boolean)bool, (String)"\u6839\u636e\u624b\u673a\u53f7\u66f4\u65b0\u767b\u5f55\u6b21\u6570\u5931\u8d25\uff01", (Object[])new Object[0]);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorPhoneEntity> entities = this.visitorPhoneRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorPhoneRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.visitorPhoneEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorPhoneEntity.class, VisitorPhoneVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorPhoneEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    private void createValidation(VisitorPhoneDto dto) {
        this.validation(dto);
    }

    private void updateValidation(VisitorPhoneDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u5173\u8054\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(VisitorPhoneDto dto) {
        Validate.notNull((Object)dto, (String)"\u6e38\u5ba2\u624b\u673a\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPhone(), (String)"\u7528\u6237\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

