package com.biz.crm.mdm.business.visitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 游客手机表(VisitorPhone)实体类
 *
 * @author xi.peng
 * @since 2022-08-30 17:23:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_visitor_phone")
@TableName(value = "mdm_visitor_phone")
@ApiModel(value = "VisitorPhone", description = "游客手机表")
@org.hibernate.annotations.Table(appliesTo = "mdm_visitor_phone", comment = "游客手机表")
public class VisitorPhoneEntity extends TenantFlagOpEntity {

  @ApiModelProperty("关联账号")
  @TableField(value = "account")
  @Column(name = "account", length = 64, columnDefinition = "varchar(64) COMMENT '关联账号'")
  private String account;

  @ApiModelProperty("用户唯一识别号")
  @TableField(value = "phone")
  @Column(name = "phone", length = 64, columnDefinition = "varchar(64) COMMENT '用户唯一识别号'")
  private String phone;

  @ApiModelProperty("登录次数")
  @TableField(value = "login_times")
  @Column(name = "login_times", length = -1, columnDefinition = "int COMMENT '登录次数'")
  private Integer loginTimes;
}
