package com.biz.crm.mdm.business.visitor.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.visitor.local.entity.VisitorAccountEntity;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorAccountPageDto;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import org.apache.ibatis.annotations.Param;

/**
 * 游客账号表(VisitorAccount)表数据库访问层
 *
 * @author xi.peng
 * @since 2022-08-30 17:22:27
 */
public interface VisitorAccountMapper extends BaseMapper<VisitorAccountEntity> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<VisitorAccountVo> findByConditions(Page<VisitorAccountPageDto> page, @Param("dto") VisitorAccountPageDto dto);

}

