/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.visitor.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.visitor.local.entity.VisitorAccountEntity;
import com.biz.crm.mdm.business.visitor.local.entity.VisitorPhoneEntity;
import com.biz.crm.mdm.business.visitor.local.repository.VisitorAccountRepository;
import com.biz.crm.mdm.business.visitor.local.repository.VisitorPhoneRepository;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorAccountDto;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorAccountPageDto;
import com.biz.crm.mdm.business.visitor.sdk.event.VisitorAccountEventListener;
import com.biz.crm.mdm.business.visitor.sdk.service.VisitorAccountVoService;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitorAccountVoServiceImpl
implements VisitorAccountVoService {
    private static final Logger log = LoggerFactory.getLogger(VisitorAccountVoServiceImpl.class);
    @Autowired
    private VisitorAccountRepository visitorAccountRepository;
    @Autowired
    private VisitorPhoneRepository visitorPhoneRepository;
    @Autowired(required=false)
    private List<VisitorAccountEventListener> visitorAccountEventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<VisitorAccountVo> findByConditions(Pageable pageable, VisitorAccountPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new VisitorAccountPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.visitorAccountRepository.findByConditions((Page<VisitorAccountPageDto>)page, dto);
    }

    public VisitorAccountVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VisitorAccountEntity entity = this.visitorAccountRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public VisitorAccountVo findByAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        VisitorAccountEntity entity = this.visitorAccountRepository.findByAccount(TenantUtils.getTenantCode(), account);
        if (entity == null) {
            return null;
        }
        return (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public VisitorAccountVo findDefaultAccount() {
        VisitorAccountEntity entity = this.visitorAccountRepository.findDefaultAccount(TenantUtils.getTenantCode());
        if (entity == null) {
            return null;
        }
        return (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(VisitorAccountDto dto) {
        this.createValidation(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setEffectiveTime(ObjectUtils.isEmpty((Object)dto.getEffectiveTime()) ? new Date() : dto.getEffectiveTime());
        dto.setExpireTime(ObjectUtils.isEmpty((Object)dto.getExpireTime()) ? new Date(9999, 11, 30) : dto.getExpireTime());
        if (BooleanEnum.TRUE.getCapital().equals(dto.getIsDefault())) {
            VisitorAccountEntity entity = this.visitorAccountRepository.findDefaultAccount(TenantUtils.getTenantCode());
            Validate.isTrue((entity == null ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01", (Object[])new Object[0]);
        } else {
            dto.setIsDefault(BooleanEnum.FALSE.getCapital());
        }
        String ruleCode = StringUtils.join((Object[])new String[]{"YK", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        dto.setAccount((String)codeList.get(0));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u521b\u5efa\u6e38\u5ba2\u8d26\u53f7\u65f6\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01", (Object[])new Object[0]);
        VisitorAccountEntity entity = (VisitorAccountEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, VisitorAccountEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.visitorAccountRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.visitorAccountEventListeners)) {
            VisitorAccountVo vo = (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorAccountEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    @Transactional
    public void update(VisitorAccountDto dto) {
        List<VisitorPhoneEntity> visitorPhoneEntityList;
        this.updateValidation(dto);
        VisitorAccountEntity oldEntity = this.visitorAccountRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getIsDefault().equals(dto.getIsDefault()), (String)"\u4e0d\u80fd\u4fee\u6539\u662f\u5426\u9ed8\u8ba4\uff01", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(oldEntity.getAttribute()) && BooleanEnum.FALSE.getCapital().equals(dto.getAttribute()) && CollectionUtils.isNotEmpty(visitorPhoneEntityList = this.visitorPhoneRepository.findByAccount(TenantUtils.getTenantCode(), oldEntity.getAccount()))) {
            Validate.isTrue((visitorPhoneEntityList.size() <= 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6e38\u5ba2\u8d26\u53f7\u5df2\u7ecf\u88ab\u591a\u4e2a\u7528\u6237\u624b\u673a\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\u8d26\u6237\u5c5e\u6027\uff01", (Object[])new Object[0]);
        }
        VisitorAccountEntity entity = (VisitorAccountEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, VisitorAccountEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.visitorAccountRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.visitorAccountEventListeners)) {
            VisitorAccountVo oldVo = (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            VisitorAccountVo newVo = (VisitorAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorAccountEventListeners.forEach(event -> event.onUpdate(oldVo, newVo));
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorAccountEntity> entities = this.visitorAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorAccountRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.visitorAccountEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorAccountEntity.class, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorAccountEventListeners.forEach(event -> event.onEnable(voList));
        }
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorAccountEntity> entities = this.visitorAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorAccountRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.visitorAccountEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorAccountEntity.class, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorAccountEventListeners.forEach(event -> event.onDisable(voList));
        }
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VisitorAccountEntity> entities = this.visitorAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitorAccountRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.visitorAccountEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, VisitorAccountEntity.class, VisitorAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.visitorAccountEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    private void createValidation(VisitorAccountDto dto) {
        this.validation(dto);
    }

    private void updateValidation(VisitorAccountDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(VisitorAccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u6e38\u5ba2\u8d26\u53f7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAttribute(), (String)"\u8d26\u53f7\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRoleCode(), (String)"\u5173\u8054\u7684\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRoleName(), (String)"\u5173\u8054\u7684\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

