package com.biz.crm.mdm.business.visitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.visitor.sdk.service.VisitorAccountVoService;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorAccountPageDto;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorAccountDto;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * 游客账号表(VisitorAccount)表控制层
 *
 * @author xi.peng
 * @since 2022-08-30 17:22:29
 */
@Slf4j
@Api(tags = "游客账号表：VisitorAccountVo")
@RestController
@RequestMapping(value = {"/v1/visitorAccount/visitorAccountVo"})
public class VisitorAccountVoController {

  @Autowired
  private VisitorAccountVoService visitorAccountVoService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<VisitorAccountVo>> findByConditions(@PageableDefault(50) Pageable pageable, VisitorAccountPageDto dto) {
    try {
      Page<VisitorAccountVo> result = this.visitorAccountVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<VisitorAccountVo> findDetailById(@RequestParam("id") String id) {
    try {
      VisitorAccountVo vo = this.visitorAccountVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据游客账号获取游客信息")
  @GetMapping(value = {"/findByAccount"})
  public Result<VisitorAccountVo> findByAccount(@RequestParam("account") String account) {
    try {
      VisitorAccountVo visitorAccountVo = this.visitorAccountVoService.findByAccount(account);
      return Result.ok(visitorAccountVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "获取默认游客账号")
  @GetMapping(value = {"/findByDefaultAccount"})
  public Result<VisitorAccountVo> findByDefaultAccount() {
    try {
      VisitorAccountVo visitorAccountVo = this.visitorAccountVoService.findDefaultAccount();
      return Result.ok(visitorAccountVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result create(@RequestBody VisitorAccountDto dto) {
    try {
      this.visitorAccountVoService.create(dto);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result update(@RequestBody VisitorAccountDto dto) {
    try {
      this.visitorAccountVoService.update(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.visitorAccountVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.visitorAccountVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.visitorAccountVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
