package com.biz.crm.mdm.business.visitor.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.visitor.sdk.event.VisitorAccountEventListener;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/26 17:16
 * @ClassName VisitorAccountEventListenerImpl
 * @Description TODO 游客账号管理事件监听
 */
@Component
public class VisitorAccountEventListenerImpl implements VisitorAccountEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新建事件监听
     * @param vo
     */
    @Override
    public void onCreate(VisitorAccountVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject(vo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 编辑事件监听
     * @param oldVo
     * @param newVo
     */
    @Override
    public void onUpdate(VisitorAccountVo oldVo, VisitorAccountVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启用数据监听
     * @param list
     */
    @Override
    public void onEnable(List<VisitorAccountVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(visitorAccountVo -> {
            String onlyKey = visitorAccountVo.getId();
            VisitorAccountVo newObj = new VisitorAccountVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            VisitorAccountVo oldObj = new VisitorAccountVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            this.onUpdate(oldObj,newObj);
        });
    }

    /**
     * 禁用数据事件监听
     * @param list
     */
    @Override
    public void onDisable(List<VisitorAccountVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(visitorAccountVo -> {
            String onlyKey = visitorAccountVo.getId();
            VisitorAccountVo newObj = new VisitorAccountVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            VisitorAccountVo oldObj = new VisitorAccountVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.onUpdate(oldObj,newObj);
        });
    }

    /**
     * 删除事件监听
     * @param list
     */
    @Override
    public void onDelete(List<VisitorAccountVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(visitorAccountVo -> {
            String onlyKey = visitorAccountVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(visitorAccountVo);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}
