package com.biz.crm.mdm.business.visitor.sdk.event;

import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * 游客账号表变更事件通知接口
 *
 * @author xi.peng
 * @since 2022-08-30 17:02:51
 */
public interface VisitorAccountEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(VisitorAccountVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(VisitorAccountVo oldVo, VisitorAccountVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<VisitorAccountVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<VisitorAccountVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<VisitorAccountVo> list) {

  }
}

