package com.biz.crm.mdm.business.visitor.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhonePageDto;
import com.biz.crm.mdm.business.visitor.sdk.dto.VisitorPhoneDto;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorPhoneVo;

import java.util.List;

import org.springframework.data.domain.Pageable;

/**
 * 游客手机表(VisitorPhone)表服务接口
 *
 * @author xi.peng
 * @since 2022-08-30 17:16:09
 */
public interface VisitorPhoneVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<VisitorPhoneVo> findByConditions(Pageable pageable, VisitorPhonePageDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  VisitorPhoneVo findDetailById(String id);

  /**
   * 按游客账号查询详情
   *
   * @param account
   * @return
   */
  List<VisitorPhoneVo> findByAccount(String account);

  /**
   * 按默认游客账号查询详情
   *
   * @return
   */
  List<VisitorPhoneVo> findByDefaultAccount();

  /**
   * 创建（根据自定义选中游客账号创建）
   *
   * @param dto
   * @return
   */
  void create(VisitorPhoneDto dto);

  /**
   * 创建（根据默认游客账号创建）
   *
   * @param dto
   * @return
   */
  void createByDefaultAccount(VisitorPhoneDto dto);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(VisitorPhoneDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据手机号更新登录次数
   *
   * @param phone
   */
  void updateLoginTimesByPhone(String phone);
}
