package com.biz.crm.mdm.business.warehouse.feign.feign.internal;
/**
 * Created by Bao Hongbin on 2022-01-11 16:03.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.warehouse.feign.feign.WarehouseVoServiceFeign;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @program: crm-dms
 * @description:
 * @author: Bao Hongbin
 * @create: 2022-01-11 16:03
 **/
@Component
public class WarehouseVoServiceFeignImpl implements FallbackFactory<WarehouseVoServiceFeign> {

  @Override
  public WarehouseVoServiceFeign create(Throwable throwable) {
    return new WarehouseVoServiceFeign() {
      @Override
      public Result<WarehouseVo> findDetailsByCode(String warehouseCode) {
        throw new UnsupportedOperationException("根据仓库编码获取仓库信息熔断");
      }

      @Override
      public Result<WarehouseVo> findDetailsByCityCode(String cityCode) {
        throw new UnsupportedOperationException("通过覆盖区域市Code获取仓库信息熔断");
      }

      @Override
      public Result<WarehouseVo> findDetailsByWarehouseDefault(Boolean bool) {
        throw new UnsupportedOperationException("获取默认仓库熔断");
      }
    };
  }
}
