package com.biz.crm.mdm.business.warehouse.feign.service.internal;
/**
 * Created by Bao Hongbin on 2022-01-11 16:36.
 */

import com.biz.crm.mdm.business.warehouse.feign.feign.WarehouseVoServiceFeign;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: crm-dms
 * @description: 仓库sdk实现
 * @author: Bao Hongbin
 * @create: 2022-01-11 16:36
 **/
@Service
public class WarehouseVoServiceImpl implements WarehouseVoService {

  @Autowired(required = false)
  private WarehouseVoServiceFeign warehouseVoServiceFeign;

  @Override
  public WarehouseVo findDetailsByCode(String warehouseCode) {
    if(StringUtils.isBlank(warehouseCode)){
      return null;
    }
    return warehouseVoServiceFeign.findDetailsByCode(warehouseCode).checkFeignResult();
  }

  @Override
  public WarehouseVo findDetailsByCityCode(String cityCode) {
    if(StringUtils.isBlank(cityCode)){
      return null;
    }
    return warehouseVoServiceFeign.findDetailsByCityCode(cityCode).checkFeignResult();
  }

  @Override
  public WarehouseVo findDetailsByWarehouseDefault(Boolean bool) {
    if(bool == null){
      return null;
    }
    return warehouseVoServiceFeign.findDetailsByWarehouseDefault(bool).checkFeignResult();
  }
}
