package com.biz.crm.mdm.business.warehouse.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.warehouse.feign.feign.internal.WarehouseVoServiceFeignImpl;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by Bao Hongbin on 2022-01-11 16:02.
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = WarehouseVoServiceFeignImpl.class)
public interface WarehouseVoServiceFeign {
  /**
   * 根据仓库编码获取仓库信息
   *
   * @param code
   * @return
   */
  @GetMapping("/v1/warehouse/warehouse/findDetailsByCode")
  Result<WarehouseVo> findDetailsByCode(@RequestParam("code") String code);

  /**
   * 通过覆盖区域市Code获取仓库信息
   * @param cityCode
   * @return
   */
  @GetMapping("/v1/warehouse/warehouse/findDetailsByCityCode")
  Result<WarehouseVo> findDetailsByCityCode(@RequestParam("cityCode") String cityCode);

  /**
   * 获取默认仓库
   * @param bool
   * @return
   */
  @GetMapping("/v1/warehouse/warehouse/findDetailsByWarehouseDefault")
  Result<WarehouseVo> findDetailsByWarehouseDefault(@RequestParam("bool") Boolean bool);
}
