package com.biz.crm.mdm.business.warehouse.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 仓库覆盖区域实体类
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WarehouseCoverageEntity", description = "仓库覆盖区域实体类")
@Entity
@TableName("mdm_warehouse_coverage")
@Table(name = "mdm_warehouse_coverage", indexes = {
    @Index(name = "mdm_warehouse_index1", columnList = "warehouse_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_warehouse_coverage", comment = "仓库覆盖区域表")
public class WarehouseCoverageEntity extends UuidEntity {

  private static final long serialVersionUID = -6252595536885613131L;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  @Column(name = "warehouse_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '仓库编码'")
  private String warehouseCode;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 省
   */
  @ApiModelProperty("省")
  @Column(name = "province_name", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市编码'")
  private String cityCode;

  /**
   * 市
   */
  @ApiModelProperty("市")
  @Column(name = "city_name", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区编码'")
  private String districtCode;

  /**
   * 区
   */
  @ApiModelProperty("区")
  @Column(name = "district_name", length = 64, columnDefinition = "varchar(64) COMMENT '区'")
  private String districtName;

}
