package com.biz.crm.mdm.business.warehouse.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehouseDto;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 仓库表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-19 10:27:14
 */
public interface WarehouseService {

  /**
   * 创建仓库
   *
   * @param dto 参数dto
   * @return 创建的仓库
   */
  WarehouseEntity create(WarehouseDto dto);

  /**
   * 更新仓库
   *
   * @param dto 参数dto
   * @return 更新的仓库
   */
  WarehouseEntity update(WarehouseDto dto);

  /**
   * 批量删除仓库
   *
   * @param ids 仓库id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用仓库
   *
   * @param ids 仓库id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用仓库
   *
   * @param ids 仓库id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 仓库分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<WarehouseEntity> 仓库分页信息
   */
  Page<WarehouseEntity> findByConditions(Pageable pageable, WarehousePageDto dto);

  /**
   * 通过ID获取仓库信息
   *
   * @param id 仓库ID
   * @return 仓库信息
   */
  WarehouseEntity findById(String id);

}
