/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/warehouse/warehouse"})
@Api(tags={"\u4ed3\u5e93\u4fe1\u606f: WarehouseVo: \u4ed3\u5e93\u7ba1\u7406"})
public class WarehouseVoController {
    private static final Logger log = LoggerFactory.getLogger(WarehouseVoController.class);
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;

    @ApiOperation(value="\u4ed3\u5e93\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<WarehouseVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="WarehousePageDto", value="\u5206\u9875Dto") WarehousePageDto dto) {
        try {
            return Result.ok((Object)this.warehouseVoService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7code\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f")
    @GetMapping(value={"/findDetailsByCode"})
    public Result<WarehouseVo> findDetailsByCode(@RequestParam(value="code", required=false) @ApiParam(name="code", value="\u4ed3\u5e93\u7f16\u7801") String code) {
        try {
            return Result.ok((Object)this.warehouseVoService.findDetailsByCode(code));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8986\u76d6\u533a\u57df\u5e02Code\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f")
    @GetMapping(value={"/findDetailsByCityCode"})
    public Result<WarehouseVo> findDetailsByCityCode(@RequestParam(value="cityCode", required=false) @ApiParam(name="cityCode", value="\u76d6\u533a\u57df\u5e02Code") String cityCode) {
        try {
            return Result.ok((Object)this.warehouseVoService.findDetailsByCityCode(cityCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9ed8\u8ba4\u4ed3\u5e93")
    @GetMapping(value={"/findDetailsByWarehouseDefault"})
    public Result<WarehouseVo> findDetailsByWarehouseDefault(@RequestParam(value="bool", required=false) @ApiParam(name="bool") Boolean bool) {
        try {
            return Result.ok((Object)this.warehouseVoService.findDetailsByWarehouseDefault(bool));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

