/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseCoverageEntity;
import com.biz.crm.mdm.business.warehouse.local.repository.WarehouseCoverageRepository;
import com.biz.crm.mdm.business.warehouse.local.service.WarehouseCoverageService;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehouseCoverageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="warehouseCoverageService")
public class WarehouseCoverageServiceImpl
implements WarehouseCoverageService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseCoverageServiceImpl.class);
    @Autowired(required=false)
    private WarehouseCoverageRepository warehouseCoverageRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<WarehouseCoverageDto> dtoList, String warehouseCode) {
        Validate.notBlank((CharSequence)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.warehouseCoverageRepository.deleteByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        this.validate(dtoList, warehouseCode);
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getProvinceCode())).map(dto -> {
            WarehouseCoverageEntity entity = (WarehouseCoverageEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, WarehouseCoverageEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setWarehouseCode(warehouseCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.warehouseCoverageRepository.saveBatch(entities);
    }

    private void validate(List<WarehouseCoverageDto> dtoList, String warehouseCode) {
        HashSet<String> set = new HashSet<String>();
        for (WarehouseCoverageDto item : dtoList) {
            String provinceAndCity = item.getProvinceCode().concat(item.getCityCode());
            if (set.add(provinceAndCity)) continue;
            Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u4ed3\u5e93\u8986\u76d6\u533a\u57df\u5b58\u5728\u91cd\u590d\u57ce\u5e02:[%s][%s]", (Object[])new Object[]{item.getProvinceName(), item.getCityName()});
        }
        for (WarehouseCoverageDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getCityCode(), (String)"\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            tenantCode = StringUtils.isEmpty((CharSequence)tenantCode) ? "default" : tenantCode;
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.warehouseCoverageRepository.lambdaQuery().eq(WarehouseCoverageEntity::getCityCode, (Object)dto.getCityCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).ne(WarehouseCoverageEntity::getWarehouseCode, (Object)warehouseCode)).list();
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"[%s][%s]\u5df2\u6709[%s]\u4e2a\u4ed3\u5e93\u8986\u76d6", (Object[])new Object[]{dto.getProvinceName(), dto.getCityName(), list.size()});
        }
    }
}

