package com.biz.crm.mdm.business.warehouse.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 仓库信息: WarehouseVo: 仓库管理
 *
 * @author ning.zhang
 * @date 2022/3/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/warehouse/warehouse")
@Api(tags = "仓库信息: WarehouseVo: 仓库管理")
public class WarehouseVoController {
  @Autowired(required = false)
  private WarehouseVoService warehouseVoService;

  /**
   * 仓库分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 仓库分页数据
   */
  @ApiOperation(value = "仓库分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<WarehouseVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "WarehousePageDto", value = "分页Dto") WarehousePageDto dto) {
    try {
      return Result.ok(this.warehouseVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过Code获取仓库信息
   *
   * @param code 仓库code
   * @return 操作结果
   */
  @ApiOperation(value = "通过code获取仓库信息")
  @GetMapping("/findDetailsByCode")
  public Result<WarehouseVo> findDetailsByCode(@RequestParam(value = "code", required = false) @ApiParam(name = "code", value = "仓库编码") String code) {
    try {
      return Result.ok(this.warehouseVoService.findDetailsByCode(code));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过覆盖区域市Code获取仓库信息
   *
   * @param cityCode
   * @return 操作结果
   */
  @ApiOperation(value = "通过覆盖区域市Code获取仓库信息")
  @GetMapping("/findDetailsByCityCode")
  public Result<WarehouseVo> findDetailsByCityCode(@RequestParam(value = "cityCode", required = false) @ApiParam(name = "cityCode", value = "盖区域市Code") String cityCode) {
    try {
      return Result.ok(this.warehouseVoService.findDetailsByCityCode(cityCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取默认仓库
   *
   * @param bool
   * @return 操作结果
   */
  @ApiOperation(value = "获取默认仓库")
  @GetMapping("/findDetailsByWarehouseDefault")
  public Result<WarehouseVo> findDetailsByWarehouseDefault(@RequestParam(value = "bool", required = false) @ApiParam(name = "bool") Boolean bool) {
    try {
      return Result.ok(this.warehouseVoService.findDetailsByWarehouseDefault(bool));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
