package com.biz.crm.mdm.business.warehouse.local.entity;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * 仓库实体类
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WarehouseEntity", description = "仓库实体类")
@Entity
@TableName("mdm_warehouse")
@Table(name = "mdm_warehouse", indexes = {
    @Index(name = "mdm_warehouse_index1", columnList = "warehouse_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "mdm_warehouse", comment = "仓库表")
public class WarehouseEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 852751698824093284L;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  @Column(name = "warehouse_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '仓库名称'")
  private String warehouseName;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  @Column(name = "warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '仓库编码'")
  private String warehouseCode;

  /**
   * 仓库地址
   */
  @ApiModelProperty("仓库地址")
  @Column(name = "warehouse_address", columnDefinition = "VARCHAR(255) COMMENT '仓库地址'")
  private String warehouseAddress;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市编码'")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区编码'")
  private String districtCode;

  /**
   * 仓库责任人
   */
  @ApiModelProperty("仓库责任人")
  @Column(name = "warehouse_head", length = 32, columnDefinition = "VARCHAR(32) COMMENT '仓库责任人'")
  private String warehouseHead;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  @Column(name = "contact_phone", length = 64, columnDefinition = "varchar(64) COMMENT '联系人电话'")
  private String contactPhone;

  /**
   * 默认仓库(true:是,false:否)
   */
  @ApiModelProperty("默认仓库(true:是,false:否)")
  @Column(name = "warehouse_default", columnDefinition = "int(1) COMMENT '默认仓库,1是0否'")
  private Boolean warehouseDefault;

  /**
   * 仓库与覆盖区域关联信息
   */
  @ApiModelProperty("仓库与覆盖区域关联信息")
  @Transient
  @TableField(exist = false)
  private List<WarehouseCoverageEntity> coverageList;
}
