package com.biz.crm.mdm.business.warehouse.local.init;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.local.repository.WarehouseRepository;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 这个初始化逻辑主要是为了系统初始化时判断仓库数据中是否存在默认仓库,没有默认仓库时自动生成默认仓库
 *
 * @author ning.zhang
 * @date 2022/1/18
 */
@Component
public class DefaultWarehouseInitProcessEnvironmentService implements InitProcessEnvironmentService {

  @Autowired(required = false)
  private WarehouseRepository warehouseRepository;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  /**
   * 1. 判断是否存在默认仓库信息
   * 2. 如果没有默认仓库信息,生成默认仓库信息
   *
   * @param appCode 顶级租户编码
   */
  @Override
  public void initForAppCode(String appCode) {
    List<WarehouseEntity> entities = this.warehouseRepository.findByWarehouseDefault(Boolean.TRUE);
    if (CollectionUtils.isEmpty(entities)) {
      WarehouseEntity entity = new WarehouseEntity();
      entity.setWarehouseDefault(Boolean.TRUE);
      entity.setWarehouseCode(this.generateCodeService.generateCode("CK", 1).get(0));
      entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      this.warehouseRepository.save(entity);
    } else {
      Validate.isTrue(entities.size() == 1,"默认仓库数量大于1,系统无法正常使用仓库数据,请检查默认仓库数据");
    }
  }

  @Override
  public boolean doInitForAppCode(String appCode) {
    return true;
  }
}
