/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.local.service.WarehouseService;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehouseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/warehouse/warehouse"})
@Api(tags={"\u4ed3\u5e93\u4fe1\u606f: Warehouse: \u4ed3\u5e93\u7ba1\u7406"})
public class WarehouseController {
    private static final Logger log = LoggerFactory.getLogger(WarehouseController.class);
    @Autowired(required=false)
    private WarehouseService warehouseService;

    @ApiOperation(value="\u65b0\u589e\u4ed3\u5e93")
    @PostMapping(value={""})
    public Result create(@RequestBody WarehouseDto dto) {
        try {
            return Result.ok((Object)((Object)this.warehouseService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4ed3\u5e93\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result update(@RequestBody WarehouseDto dto) {
        try {
            return Result.ok((Object)((Object)this.warehouseService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.warehouseService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result enableBatch(@RequestBody List<String> ids) {
        try {
            this.warehouseService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result disableBatch(@RequestBody List<String> ids) {
        try {
            this.warehouseService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<WarehouseEntity> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            return Result.ok((Object)((Object)this.warehouseService.findById(id)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

