/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.local.repository.WarehouseRepository;
import com.biz.crm.mdm.business.warehouse.local.service.WarehouseService;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WarehouseVoServiceImpl
implements WarehouseVoService {
    @Autowired(required=false)
    private WarehouseRepository warehouseRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private WarehouseService warehouseService;
    @Autowired(required=false)
    private RegionVoService regionVoService;

    public WarehouseVo findDetailsByCode(String warehouseCode) {
        WarehouseEntity entity = this.warehouseRepository.findDetailsByCode(warehouseCode);
        Validate.notNull((Object)((Object)entity), (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (WarehouseVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public WarehouseVo findDetailsByCityCode(String cityCode) {
        if (StringUtils.isBlank((CharSequence)cityCode)) {
            return null;
        }
        WarehouseEntity entity = this.warehouseRepository.findDetailsByCityCode(cityCode);
        if (entity == null) {
            return null;
        }
        return (WarehouseVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public WarehouseVo findDetailsByWarehouseDefault(Boolean bool) {
        if (bool == null) {
            return null;
        }
        WarehouseEntity entity = this.warehouseRepository.findDetailsByWarehouseDefault(bool);
        if (entity == null) {
            return null;
        }
        return (WarehouseVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<WarehouseVo> findByConditions(Pageable pageable, WarehousePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (WarehousePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new WarehousePageDto());
        Page<WarehouseEntity> entityPage = this.warehouseService.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)entityPage.getRecords())) {
            pageResult.setRecords(this.convertEntityToVo(entityPage.getRecords()));
        }
        return pageResult;
    }

    private List<WarehouseVo> convertEntityToVo(List<WarehouseEntity> entities) {
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, WarehouseEntity.class, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]));
        ArrayList regionCodes = Lists.newArrayList();
        list.forEach(warehouseVo -> {
            if (StringUtils.isNotBlank((CharSequence)warehouseVo.getCityCode())) {
                regionCodes.add(warehouseVo.getCityCode());
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseVo.getProvinceCode())) {
                regionCodes.add(warehouseVo.getProvinceCode());
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseVo.getDistrictCode())) {
                regionCodes.add(warehouseVo.getDistrictCode());
            }
        });
        if (CollectionUtils.isEmpty((Collection)regionCodes)) {
            return list;
        }
        Map regionCodeNameMap = this.regionVoService.findRegionCodeNameMap((List)regionCodes);
        list.forEach(warehouseVo -> {
            warehouseVo.setProvinceName((String)regionCodeNameMap.get(warehouseVo.getProvinceCode()));
            warehouseVo.setCityName((String)regionCodeNameMap.get(warehouseVo.getCityCode()));
            warehouseVo.setDistrictName((String)regionCodeNameMap.get(warehouseVo.getDistrictCode()));
        });
        return list;
    }
}

