package com.biz.crm.mdm.business.warehouse.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 仓库表的mybatis-plus接口类 {@link WarehouseEntity}
 *
 * @author ning.zhang
 * @date 2021-11-19 10:27:13
 */
public interface WarehouseMapper extends BaseMapper<WarehouseEntity> {
  
  /**
   * 仓库分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<WarehouseEntity> findByConditions(Page<WarehouseEntity> page,
      @Param("dto") WarehousePageDto dto, @Param("tenantCode") String tenantCode);
  
  /**
   * 通过ID获取仓库信息
   *
   * @param id 仓库ID
   * @return 仓库信息
   */
  WarehouseEntity findById(@Param("id") String id, @Param("tenantCode") String tenantCode);
  
  /**
   * 通过覆盖区域市Code获取仓库信息
   * 
   * @param cityCode
   * @return
   */
  WarehouseEntity findDetailsByCityCode(@Param("cityCode") String cityCode,
      @Param("tenantCode") String tenantCode);
  
  /**
   * 获取默认仓库
   * 
   * @param bool
   * @return
   */
  WarehouseEntity findDetailsByWarehouseDefault(@Param("bool") Boolean bool,
      @Param("tenantCode") String tenantCode);
}

