package com.biz.crm.mdm.business.warehouse.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseCoverageEntity;
import com.biz.crm.mdm.business.warehouse.local.mapper.WarehouseCoverageMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 仓库覆盖区域表的数据库访问类 {@link WarehouseCoverageEntity}
 *
 * @author ning.zhang
 * @date 2021-11-19 10:27:45
 */
@Component
public class WarehouseCoverageRepository extends ServiceImpl<WarehouseCoverageMapper, WarehouseCoverageEntity> {

  /**
   * 通过仓库编码删除仓库销售区域(物理删除 编辑时用)
   *
   * @param warehouseCode 仓库编码
   */
  public void deleteByWarehouseCode(String warehouseCode) {
    this.lambdaUpdate()
        .eq(WarehouseCoverageEntity::getWarehouseCode, warehouseCode)
        .eq(WarehouseCoverageEntity::getTenantCode, TenantUtils.getTenantCode())
        .remove();
  }

  /**
   * 通过仓库编码删除仓库销售区域（逻辑删除）
   *
   * @param warehouseCodes 仓库编码
   */
  public void deleteByWarehouseCodes(List<String> warehouseCodes) {
    this.lambdaUpdate()
        .in(WarehouseCoverageEntity::getWarehouseCode, warehouseCodes)
        .eq(WarehouseCoverageEntity::getTenantCode, TenantUtils.getTenantCode())
        .remove();
  }

  /**
   * 根据城市编码查询
   * @param cityCode  code不唯一 结果值为集合
   */
  public List<WarehouseCoverageEntity> findByCityCode(String cityCode) {
    return this.lambdaQuery()
            .eq(WarehouseCoverageEntity::getCityCode, cityCode)
            .eq(WarehouseCoverageEntity::getTenantCode, TenantUtils.getTenantCode())
            .list();
  }
}
