/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.warehouse.sdk.event.WarehouseEventListener;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseEventVo;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WarehouseEventLogListenerImpl
implements WarehouseEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(WarehouseEventVo vo) {
        WarehouseVo newest = vo.getNewWarehouse();
        WarehouseVo original = vo.getOldWarehouse();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(WarehouseEventVo vo) {
        WarehouseVo newest = vo.getNewWarehouse();
        WarehouseVo original = vo.getOldWarehouse();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onDisable(WarehouseEventVo vo) {
        List warehouseVoList = vo.getWarehouseVoList();
        if (CollectionUtils.isEmpty((Collection)warehouseVoList)) {
            return;
        }
        warehouseVoList.forEach(warehouseVo -> {
            String onlyKey = warehouseVo.getId();
            WarehouseVo oldObj = new WarehouseVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(warehouseVo.getEnableStatus());
            WarehouseVo newObj = new WarehouseVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            WarehouseEventVo warehouseEventVo = new WarehouseEventVo();
            warehouseEventVo.setOldWarehouse(oldObj);
            warehouseEventVo.setNewWarehouse(newObj);
            this.onUpdate(warehouseEventVo);
        });
    }

    public void onEnable(WarehouseEventVo vo) {
        List warehouseVoList = vo.getWarehouseVoList();
        if (CollectionUtils.isEmpty((Collection)warehouseVoList)) {
            return;
        }
        warehouseVoList.forEach(warehouseVo -> {
            String onlyKey = warehouseVo.getId();
            WarehouseVo oldObj = new WarehouseVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(warehouseVo.getEnableStatus());
            WarehouseVo newObj = new WarehouseVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            WarehouseEventVo warehouseEventVo = new WarehouseEventVo();
            warehouseEventVo.setOldWarehouse(oldObj);
            warehouseEventVo.setNewWarehouse(newObj);
            this.onUpdate(warehouseEventVo);
        });
    }

    public void onDelete(WarehouseEventVo vo) {
        List warehouseVoList = vo.getWarehouseVoList();
        if (CollectionUtils.isEmpty((Collection)warehouseVoList)) {
            return;
        }
        warehouseVoList.forEach(warehouseVo -> {
            String onlyKey = warehouseVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(warehouseVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}

