/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.warehouse.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.warehouse.local.entity.WarehouseEntity;
import com.biz.crm.mdm.business.warehouse.local.mapper.WarehouseMapper;
import com.biz.crm.mdm.business.warehouse.local.repository.WarehouseCoverageRepository;
import com.biz.crm.mdm.business.warehouse.local.repository.WarehouseRepository;
import com.biz.crm.mdm.business.warehouse.local.service.WarehouseCoverageService;
import com.biz.crm.mdm.business.warehouse.local.service.WarehouseService;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehouseDto;
import com.biz.crm.mdm.business.warehouse.sdk.dto.WarehousePageDto;
import com.biz.crm.mdm.business.warehouse.sdk.event.WarehouseEventListener;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseEventVo;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="warehouseService")
public class WarehouseServiceImpl
implements WarehouseService {
    @Autowired(required=false)
    private WarehouseRepository warehouseRepository;
    @Autowired(required=false)
    private WarehouseCoverageRepository warehouseCoverageRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private WarehouseCoverageService warehouseCoverageService;
    @Autowired(required=false)
    @Lazy
    private List<WarehouseEventListener> listeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Resource
    private WarehouseMapper warehouseMapper;

    @Override
    @Transactional
    public WarehouseEntity create(WarehouseDto dto) {
        this.createValidation(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getWarehouseCode())) {
            dto.setWarehouseCode((String)this.generateCodeService.generateCode("CK", 1).get(0));
        }
        List<WarehouseEntity> list = this.warehouseRepository.findByCodes(Lists.newArrayList((Object[])new String[]{dto.getWarehouseCode()}));
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u4ed3\u5e93\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        WarehouseEntity entity = (WarehouseEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, WarehouseEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.warehouseRepository.save((Object)entity);
        this.warehouseCoverageService.update(dto.getCoverageList(), dto.getWarehouseCode());
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            WarehouseVo newObj = (WarehouseVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
            WarehouseEventVo warehouseEventVo = new WarehouseEventVo();
            warehouseEventVo.setNewWarehouse(newObj);
            warehouseEventVo.setOldWarehouse(null);
            this.listeners.forEach(listener -> listener.onCreate(warehouseEventVo));
        }
        return entity;
    }

    @Override
    @Transactional
    public WarehouseEntity update(WarehouseDto dto) {
        this.updateValidation(dto);
        WarehouseEntity entity = this.warehouseRepository.findByIdAndTenantCode(dto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)entity), (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getWarehouseCode().equals(dto.getWarehouseCode()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((entity.getWarehouseDefault() == false ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u4fee\u6539\u9ed8\u8ba4\u4ed3\u5e93", (Object[])new Object[0]);
        WarehouseEntity updateEntity = (WarehouseEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, WarehouseEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setTenantCode(TenantUtils.getTenantCode());
        this.warehouseRepository.updateById((Object)updateEntity);
        this.warehouseCoverageService.update(dto.getCoverageList(), dto.getWarehouseCode());
        WarehouseVo oldVo = (WarehouseVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
        WarehouseVo newVo = (WarehouseVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
        WarehouseEventVo eventVo = new WarehouseEventVo();
        eventVo.setOldWarehouse(oldVo);
        eventVo.setNewWarehouse(newVo);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            this.listeners.forEach(listener -> listener.onUpdate(eventVo));
        }
        SerializableBiConsumer & Serializable onUpdate = WarehouseEventListener::onUpdate;
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<WarehouseEntity> entities = this.warehouseRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        for (WarehouseEntity entity : entities) {
            Validate.isTrue((boolean)EnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)"[%s]\u4ed3\u5e93\u5df2\u542f\u7528\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{entity.getWarehouseName()});
        }
        List<String> warehouseCodes = entities.stream().map(WarehouseEntity::getWarehouseCode).collect(Collectors.toList());
        this.warehouseRepository.updateDelFlagByIds(ids);
        this.warehouseCoverageRepository.deleteByWarehouseCodes(warehouseCodes);
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, WarehouseEntity.class, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
        WarehouseEventVo eventVo = new WarehouseEventVo();
        eventVo.setWarehouseVoList(vos);
        SerializableBiConsumer & Serializable sf = WarehouseEventListener::onDelete;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<WarehouseEntity> entities = this.warehouseRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.warehouseRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, WarehouseEntity.class, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]));
            WarehouseEventVo eventVo = new WarehouseEventVo();
            eventVo.setWarehouseVoList((List)voList);
            this.listeners.forEach(listener -> listener.onEnable(eventVo));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.warehouseRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.warehouseRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, WarehouseEntity.class, WarehouseVo.class, HashSet.class, ArrayList.class, new String[0]));
            WarehouseEventVo eventVo = new WarehouseEventVo();
            eventVo.setWarehouseVoList((List)voList);
            this.listeners.forEach(listener -> listener.onDisable(eventVo));
        }
    }

    @Override
    public Page<WarehouseEntity> findByConditions(Pageable pageable, WarehousePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (WarehousePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new WarehousePageDto());
        return this.warehouseRepository.findByConditions(pageable, dto);
    }

    @Override
    public WarehouseEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.warehouseMapper.findById(id, TenantUtils.getTenantCode());
    }

    private void createValidation(WarehouseDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notNull((Object)dto.getWarehouseDefault(), (String)"\u7f3a\u5931\u9ed8\u8ba4\u4ed3\u5e93\u6807\u8bc6", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarehouseName(), (String)"\u7f3a\u5931\u4ed3\u5e93\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarehouseAddress(), (String)"\u7f3a\u5931\u4ed3\u5e93\u5730\u5740", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseDefault() == false ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u521b\u5efa\u9ed8\u8ba4\u4ed3\u5e93", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getLatitude(), (String)"\u7f3a\u5931\u7eac\u5ea6", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getLongitude(), (String)"\u7f3a\u5931\u7ecf\u5ea6", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseName().length() < 128 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getWarehouseCode()) || dto.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseAddress().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u5730\u5740\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getWarehouseHead()) || dto.getWarehouseHead().length() < 32 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u8d23\u4efb\u4eba\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getContactPhone()) || dto.getContactPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u7535\u8bdd\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (dto.getWarehouseDefault().booleanValue()) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)dto.getCoverageList()), (String)"\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u4ed3\u5e93\u662f\uff0c\u4e0d\u80fd\u586b\u5199\u8986\u76d6\u533a\u57df", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCoverageList()), (String)"\u8bbe\u7f6e\u4e3a\u975e\u9ed8\u8ba4\u4ed3\u5e93\u662f\uff0c\u5fc5\u987b\u586b\u5199\u8986\u76d6\u533a\u57df", (Object[])new Object[0]);
        }
    }

    private void updateValidation(WarehouseDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarehouseCode(), (String)"\u7f3a\u5931\u4ed3\u5e93\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarehouseName(), (String)"\u7f3a\u5931\u4ed3\u5e93\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarehouseAddress(), (String)"\u7f3a\u5931\u4ed3\u5e93\u5730\u5740", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getLatitude(), (String)"\u7f3a\u5931\u7eac\u5ea6", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getLongitude(), (String)"\u7f3a\u5931\u7ecf\u5ea6", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getWarehouseDefault(), (String)"\u7f3a\u5931\u9ed8\u8ba4\u4ed3\u5e93\u6807\u8bc6", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseDefault() == false ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u4fee\u6539\u9ed8\u8ba4\u4ed3\u5e93", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseName().length() < 128 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getWarehouseAddress().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u5730\u5740\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getWarehouseHead()) || dto.getWarehouseHead().length() < 32 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u8d23\u4efb\u4eba\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getContactPhone()) || dto.getContactPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u7535\u8bdd\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

