package com.biz.crm.mdm.business.warehouse.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 仓库Dto
 *
 * @author ning.zhang
 * @date 2021/11/19
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "WarehouseDto", description = "仓库Dto")
public class WarehouseDto extends UuidDto {

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库地址
   */
  @ApiModelProperty("仓库地址")
  private String warehouseAddress;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 仓库责任人
   */
  @ApiModelProperty("仓库责任人")
  private String warehouseHead;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  private String contactPhone;

  /**
   * 默认仓库(true:是,false:否)
   */
  @ApiModelProperty("默认仓库(true:是,false:否)")
  private Boolean warehouseDefault;

  /**
   * 覆盖区域
   */
  @ApiModelProperty("覆盖区域")
  private List<WarehouseCoverageDto> coverageList;
}
