package com.biz.crm.mdm.business.warehouse.sdk.vo;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 仓库事件Vo
 *
 * @author ning.zhang
 * @date 2021/10/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class WarehouseEventVo implements NebulaEventDto {
  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private WarehouseVo oldWarehouse;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private WarehouseVo newWarehouse;

  /**
   * 仓库地址
   */
  @ApiModelProperty("仓库地址")
  private List<WarehouseVo> warehouseVoList;
}
